/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import net.ftb.data.Settings;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.dialogs.EditModPackDialog;
import net.ftb.gui.dialogs.FirstRunDialog;
import net.ftb.gui.panes.OptionsPane;
import net.ftb.log.Logger;
import net.ftb.util.ErrorUtils;
import net.ftb.util.FileUtils;

public class ChooseDir
extends JFrame
implements ActionListener {
    private OptionsPane optionsPane;
    private EditModPackDialog editMPD;
    private FirstRunDialog firstRunDialog;

    public ChooseDir(OptionsPane optionsPane) {
        this.optionsPane = optionsPane;
        this.editMPD = null;
    }

    public ChooseDir(EditModPackDialog editMPD) {
        this.optionsPane = null;
        this.editMPD = editMPD;
    }

    public ChooseDir(FirstRunDialog firstRunDialog) {
        this.optionsPane = null;
        this.editMPD = null;
        this.firstRunDialog = firstRunDialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        String choosertitle = "Please select an install location";
        if (this.optionsPane != null) {
            chooser.setCurrentDirectory(new File(Settings.getSettings().getInstallPath()));
            chooser.setDialogTitle(choosertitle);
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(this) == 0) {
                Logger.logDebug("getCurrentDirectory(): " + chooser.getCurrentDirectory());
                Logger.logDebug("getSelectedFile() : " + chooser.getSelectedFile());
                this.optionsPane.setInstallFolderText(chooser.getSelectedFile().getPath());
            } else {
                Logger.logWarn("No Selection.");
            }
        } else if (this.editMPD != null) {
            if (!Settings.getSettings().getLastAddPath().isEmpty()) {
                chooser.setCurrentDirectory(new File(Settings.getSettings().getLastAddPath()));
            }
            chooser.setDialogTitle("Please select the mod to install");
            chooser.setFileSelectionMode(0);
            chooser.setAcceptAllFileFilterUsed(true);
            if (chooser.showOpenDialog(this) == 0) {
                File destination = new File(this.editMPD.folder, chooser.getSelectedFile().getName());
                if (!destination.exists()) {
                    try {
                        FileUtils.copyFile(chooser.getSelectedFile(), destination);
                        Settings.getSettings().setLastAddPath(chooser.getSelectedFile().getPath());
                        LaunchFrame.getInstance().saveSettings();
                    }
                    catch (IOException e1) {
                        Logger.logError(e1.getMessage());
                    }
                    this.editMPD.updateLists();
                } else {
                    ErrorUtils.tossError("File already exists, cannot add mod!");
                }
            } else {
                Logger.logWarn("No Selection.");
            }
        } else {
            chooser.setCurrentDirectory(new File(Settings.getSettings().getInstallPath()));
            chooser.setDialogTitle(choosertitle);
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(this) == 0) {
                Logger.logDebug("getCurrentDirectory(): " + chooser.getCurrentDirectory());
                Logger.logDebug("getSelectedFile() : " + chooser.getSelectedFile());
                this.firstRunDialog.setInstallFolderText(chooser.getSelectedFile().getPath());
            } else {
                Logger.logWarn("No Selection.");
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }
}

